/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryLock;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.NioImageBuffer;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.VirtualUniverse;

abstract class ImageComponentRetained
extends NodeComponentRetained {
    static final int IMAGE_CHANGED = 1;
    static final int SUBIMAGE_CHANGED = 2;
    static final int TYPE_BYTE_BGR = 1;
    static final int TYPE_BYTE_RGB = 2;
    static final int TYPE_BYTE_ABGR = 4;
    static final int TYPE_BYTE_RGBA = 8;
    static final int TYPE_BYTE_LA = 16;
    static final int TYPE_BYTE_GRAY = 32;
    static final int TYPE_USHORT_GRAY = 64;
    static final int TYPE_INT_BGR = 128;
    static final int TYPE_INT_RGB = 256;
    static final int TYPE_INT_ARGB = 512;
    static final int IMAGE_SIZE_512X512 = 262144;
    static final int IMAGE_DATA_TYPE_BYTE_ARRAY = 4096;
    static final int IMAGE_DATA_TYPE_INT_ARRAY = 8192;
    static final int IMAGE_DATA_TYPE_BYTE_BUFFER = 16384;
    static final int IMAGE_DATA_TYPE_INT_BUFFER = 32768;
    private int apiFormat;
    int width;
    int height;
    int depth;
    boolean byReference = false;
    boolean yUp = false;
    boolean imageTypeIsSupported;
    boolean abgrSupported = true;
    boolean npotSupported = true;
    private int unitsPerPixel;
    private int numberOfComponents;
    private int imageType;
    private ImageFormatType imageFormatType = ImageFormatType.TYPE_UNKNOWN;
    ImageData imageData;
    private ImageComponent.ImageClass imageClass = ImageComponent.ImageClass.BUFFERED_IMAGE;
    private ImageData imageDataPowerOfTwo;
    private AffineTransformOp powerOfTwoATOp;
    private boolean enforceNonPowerOfTwoSupport = false;
    private boolean usedByOffScreenCanvas = false;
    private Object[] refImage = null;
    Object evaluateExtLock = new Object();
    GeometryLock geomLock = new GeometryLock();
    int tilew = 0;
    int tileh = 0;
    int numXTiles = 0;
    int numYTiles = 0;
    ArrayList userList = new ArrayList();

    ImageComponentRetained() {
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    int getFormat() {
        return this.apiFormat;
    }

    void setFormat(int n2) {
        this.apiFormat = n2;
    }

    void setByReference(boolean bl) {
        this.byReference = bl;
    }

    boolean isByReference() {
        return this.byReference;
    }

    void setYUp(boolean bl) {
        this.yUp = bl;
    }

    boolean isYUp() {
        return this.yUp;
    }

    int getUnitsPerPixel() {
        return this.unitsPerPixel;
    }

    void setUnitsPerPixel(int n2) {
        this.unitsPerPixel = n2;
    }

    ImageComponent.ImageClass getImageClass() {
        return this.imageClass;
    }

    void setImageClass(RenderedImage renderedImage) {
        this.imageClass = renderedImage instanceof BufferedImage ? ImageComponent.ImageClass.BUFFERED_IMAGE : ImageComponent.ImageClass.RENDERED_IMAGE;
    }

    void setImageClass(NioImageBuffer nioImageBuffer) {
        this.imageClass = ImageComponent.ImageClass.NIO_IMAGE_BUFFER;
    }

    void setEnforceNonPowerOfTwoSupport(boolean bl) {
        this.enforceNonPowerOfTwoSupport = bl;
    }

    void setUsedByOffScreen(boolean bl) {
        this.usedByOffScreenCanvas = bl;
    }

    boolean getUsedByOffScreen() {
        return this.usedByOffScreenCanvas;
    }

    int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    void setNumberOfComponents(int n2) {
        this.numberOfComponents = n2;
    }

    int getImageDataTypeIntValue() {
        int n2 = -1;
        switch (this.imageData.imageDataType) {
            case TYPE_BYTE_ARRAY: {
                n2 = 4096;
                break;
            }
            case TYPE_INT_ARRAY: {
                n2 = 8192;
                break;
            }
            case TYPE_BYTE_BUFFER: {
                n2 = 16384;
                break;
            }
            case TYPE_INT_BUFFER: {
                n2 = 32768;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return n2;
    }

    int getImageFormatTypeIntValue(boolean bl) {
        int n2 = -1;
        switch (this.imageFormatType) {
            case TYPE_BYTE_BGR: {
                n2 = 1;
                break;
            }
            case TYPE_BYTE_RGB: {
                n2 = 2;
                break;
            }
            case TYPE_BYTE_ABGR: {
                n2 = 4;
                break;
            }
            case TYPE_BYTE_RGBA: {
                if (this.imageDataPowerOfTwo != null && bl) {
                    n2 = 4;
                    break;
                }
                n2 = 8;
                break;
            }
            case TYPE_BYTE_LA: {
                n2 = 16;
                break;
            }
            case TYPE_BYTE_GRAY: {
                n2 = 32;
                break;
            }
            case TYPE_USHORT_GRAY: {
                n2 = 64;
                break;
            }
            case TYPE_INT_BGR: {
                n2 = 128;
                break;
            }
            case TYPE_INT_RGB: {
                n2 = 256;
                break;
            }
            case TYPE_INT_ARGB: {
                n2 = 512;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return n2;
    }

    int getImageType() {
        return this.imageType;
    }

    void setImageFormatType(ImageFormatType imageFormatType) {
        this.imageFormatType = imageFormatType;
    }

    ImageFormatType getImageFormatType() {
        return this.imageFormatType;
    }

    void setRefImage(Object object, int n2) {
        this.refImage[n2] = object;
    }

    Object getRefImage(int n2) {
        return this.refImage[n2];
    }

    ImageData getImageData(boolean bl) {
        if (bl) {
            assert (this.enforceNonPowerOfTwoSupport);
            if (this.imageDataPowerOfTwo != null) {
                return this.imageDataPowerOfTwo;
            }
        }
        return this.imageData;
    }

    boolean useBilinearFilter() {
        return this.imageDataPowerOfTwo != null;
    }

    boolean isImageTypeSupported() {
        return this.imageTypeIsSupported;
    }

    void processParams(int n2, int n3, int n4, int n5) {
        if (n3 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained0"));
        }
        if (n4 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained1"));
        }
        if (n5 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained2"));
        }
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                this.numberOfComponents = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                this.numberOfComponents = 4;
                break;
            }
            case 7: 
            case 8: {
                this.numberOfComponents = 2;
                break;
            }
            case 10: {
                this.numberOfComponents = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained3"));
            }
        }
        this.setFormat(n2);
        this.width = n3;
        this.height = n4;
        this.depth = n5;
        this.refImage = new Object[n5];
    }

    int evaluateImageType(RenderedImage renderedImage) {
        int n2 = 0;
        if (renderedImage instanceof BufferedImage) {
            n2 = ((BufferedImage)renderedImage).getType();
            if (n2 != 0) {
                return n2;
            }
        } else {
            return n2;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n3 = colorSpace.getType();
        boolean bl = colorModel.isAlphaPremultiplied();
        if (n3 == 6 && colorModel instanceof ComponentColorModel) {
            if (sampleModel.getDataType() == 0) {
                n2 = 10;
            } else if (sampleModel.getDataType() == 1) {
                n2 = 11;
            }
        } else if (n3 == 5) {
            int n4 = 0;
            int n5 = sampleModel.getDataType();
            if (n5 == 0) {
                n4 = 8;
            } else if (n5 == 3) {
                n4 = 32;
            }
            if (n4 != 0) {
                int n6 = sampleModel.getNumBands();
                if (colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                    PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                    int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                    ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                    int[] nArray2 = componentColorModel.getComponentSize();
                    boolean bl2 = true;
                    for (int i2 = 0; i2 < n6; ++i2) {
                        if (nArray2[i2] == n4) continue;
                        bl2 = false;
                        break;
                    }
                    if (n4 == 8) {
                        if (bl2 && nArray[0] == n6 - 1 && nArray[1] == n6 - 2 && nArray[2] == n6 - 3) {
                            if (n6 == 3) {
                                n2 = 5;
                            } else if (nArray[3] == 0) {
                                n2 = bl ? 7 : 6;
                            }
                        }
                    } else if (bl2) {
                        if (n6 == 3) {
                            if (nArray[0] == n6 - 1 && nArray[1] == n6 - 2 && nArray[2] == n6 - 3) {
                                n2 = 4;
                            } else if (nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                                n2 = 1;
                            }
                        } else if (nArray[0] == 3 && nArray[1] == 0 && nArray[2] == 1 && nArray[3] == 2) {
                            n2 = bl ? 3 : 2;
                        }
                    }
                }
            }
        }
        return n2;
    }

    boolean is3ByteRGB(RenderedImage renderedImage) {
        int n2;
        boolean bl = false;
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = colorModel.isAlphaPremultiplied();
        int n3 = colorSpace.getType();
        if (n3 == 5 && (n2 = sampleModel.getNumBands()) == 3 && sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
            int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            int[] nArray2 = componentColorModel.getComponentSize();
            boolean bl3 = true;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (nArray2[i2] == 8) continue;
                bl3 = false;
                break;
            }
            if (bl3 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                bl = true;
            }
        }
        return bl;
    }

    boolean is4ByteRGBA(RenderedImage renderedImage) {
        int n2;
        boolean bl = false;
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = colorModel.isAlphaPremultiplied();
        int n3 = colorSpace.getType();
        if (n3 == 5 && (n2 = sampleModel.getNumBands()) == 4 && sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
            int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            int[] nArray2 = componentColorModel.getComponentSize();
            boolean bl3 = true;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (nArray2[i2] == 8) continue;
                bl3 = false;
                break;
            }
            if (bl3 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2 && nArray[3] == 3 && !bl2) {
                bl = true;
            }
        }
        return bl;
    }

    boolean isSubImageTypeEqual(RenderedImage renderedImage) {
        int n2 = this.evaluateImageType(renderedImage);
        return this.imageType == n2;
    }

    void createBlankImageData() {
        assert (this.imageData == null);
        switch (this.numberOfComponents) {
            case 4: {
                this.imageType = 2;
                this.imageFormatType = ImageFormatType.TYPE_INT_ARGB;
                this.unitsPerPixel = 1;
                break;
            }
            case 3: {
                this.imageType = 1;
                this.imageFormatType = ImageFormatType.TYPE_INT_RGB;
                this.unitsPerPixel = 1;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.imageTypeIsSupported = true;
        this.imageData = this.createRenderedImageDataObject(null);
    }

    boolean isImageTypeSupported(NioImageBuffer nioImageBuffer) {
        boolean bl = true;
        NioImageBuffer.ImageType imageType = nioImageBuffer.getImageType();
        block0 : switch (this.numberOfComponents) {
            case 4: {
                switch (imageType) {
                    case TYPE_4BYTE_ABGR: {
                        if (this.abgrSupported) {
                            this.imageFormatType = ImageFormatType.TYPE_BYTE_ABGR;
                        } else {
                            this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                            bl = false;
                        }
                        this.unitsPerPixel = 4;
                        break block0;
                    }
                    case TYPE_4BYTE_RGBA: {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                        this.unitsPerPixel = 4;
                        break block0;
                    }
                    case TYPE_INT_ARGB: {
                        this.imageFormatType = ImageFormatType.TYPE_INT_ARGB;
                        this.unitsPerPixel = 1;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            case 3: {
                switch (imageType) {
                    case TYPE_3BYTE_BGR: {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_BGR;
                        this.unitsPerPixel = 3;
                        break block0;
                    }
                    case TYPE_3BYTE_RGB: {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGB;
                        this.unitsPerPixel = 3;
                        break block0;
                    }
                    case TYPE_INT_BGR: {
                        this.imageFormatType = ImageFormatType.TYPE_INT_BGR;
                        this.unitsPerPixel = 1;
                        break block0;
                    }
                    case TYPE_INT_RGB: {
                        this.imageFormatType = ImageFormatType.TYPE_INT_RGB;
                        this.unitsPerPixel = 1;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            case 2: {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            case 1: {
                if (imageType == NioImageBuffer.ImageType.TYPE_BYTE_GRAY) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_GRAY;
                    this.unitsPerPixel = 1;
                    break;
                }
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            default: {
                throw new AssertionError();
            }
        }
        return bl;
    }

    boolean isImageTypeSupported(RenderedImage renderedImage) {
        boolean bl = true;
        this.imageType = this.evaluateImageType(renderedImage);
        switch (this.numberOfComponents) {
            case 4: {
                if (this.imageType == 6) {
                    if (this.abgrSupported) {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_ABGR;
                    } else {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                        bl = false;
                    }
                    this.unitsPerPixel = 4;
                    break;
                }
                if (this.imageType == 2) {
                    this.imageFormatType = ImageFormatType.TYPE_INT_ARGB;
                    this.unitsPerPixel = 1;
                    break;
                }
                if (this.is4ByteRGBA(renderedImage)) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                    this.unitsPerPixel = 4;
                    break;
                }
                this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                bl = false;
                this.unitsPerPixel = 4;
                break;
            }
            case 3: {
                if (this.imageType == 5) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_BGR;
                    this.unitsPerPixel = 3;
                    break;
                }
                if (this.imageType == 4) {
                    this.imageFormatType = ImageFormatType.TYPE_INT_BGR;
                    this.unitsPerPixel = 1;
                    break;
                }
                if (this.imageType == 1) {
                    this.imageFormatType = ImageFormatType.TYPE_INT_RGB;
                    this.unitsPerPixel = 1;
                    break;
                }
                if (this.is3ByteRGB(renderedImage)) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_RGB;
                    this.unitsPerPixel = 3;
                    break;
                }
                this.imageFormatType = ImageFormatType.TYPE_BYTE_RGB;
                bl = false;
                this.unitsPerPixel = 3;
                break;
            }
            case 2: {
                this.imageFormatType = ImageFormatType.TYPE_BYTE_LA;
                bl = false;
                this.unitsPerPixel = 2;
                break;
            }
            case 1: {
                if (this.imageType == 10) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_GRAY;
                    this.unitsPerPixel = 1;
                    break;
                }
                this.imageFormatType = ImageFormatType.TYPE_BYTE_GRAY;
                bl = false;
                this.unitsPerPixel = 1;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return bl;
    }

    ImageData createNioImageBufferDataObject(NioImageBuffer nioImageBuffer) {
        switch (this.imageFormatType) {
            case TYPE_BYTE_BGR: 
            case TYPE_BYTE_RGB: 
            case TYPE_BYTE_ABGR: 
            case TYPE_BYTE_RGBA: 
            case TYPE_BYTE_LA: 
            case TYPE_BYTE_GRAY: {
                if (nioImageBuffer != null) {
                    return new ImageData(ImageDataType.TYPE_BYTE_BUFFER, this.width * this.height * this.depth * this.unitsPerPixel, this.width, this.height, nioImageBuffer);
                }
                return new ImageData(ImageDataType.TYPE_BYTE_BUFFER, this.width * this.height * this.depth * this.unitsPerPixel, this.width, this.height);
            }
            case TYPE_INT_BGR: 
            case TYPE_INT_RGB: 
            case TYPE_INT_ARGB: {
                return new ImageData(ImageDataType.TYPE_INT_BUFFER, this.width * this.height * this.depth * this.unitsPerPixel, this.width, this.height, nioImageBuffer);
            }
        }
        throw new AssertionError();
    }

    ImageData createRenderedImageDataObject(RenderedImage renderedImage, int n2, int n3) {
        switch (this.imageFormatType) {
            case TYPE_BYTE_BGR: 
            case TYPE_BYTE_RGB: 
            case TYPE_BYTE_ABGR: 
            case TYPE_BYTE_RGBA: 
            case TYPE_BYTE_LA: 
            case TYPE_BYTE_GRAY: {
                if (renderedImage != null) {
                    return new ImageData(ImageDataType.TYPE_BYTE_ARRAY, n2 * n3 * this.depth * this.unitsPerPixel, n2, n3, renderedImage);
                }
                return new ImageData(ImageDataType.TYPE_BYTE_ARRAY, n2 * n3 * this.depth * this.unitsPerPixel, n2, n3);
            }
            case TYPE_INT_BGR: 
            case TYPE_INT_RGB: 
            case TYPE_INT_ARGB: {
                if (renderedImage != null) {
                    return new ImageData(ImageDataType.TYPE_INT_ARRAY, n2 * n3 * this.depth * this.unitsPerPixel, n2, n3, renderedImage);
                }
                return new ImageData(ImageDataType.TYPE_INT_ARRAY, n2 * n3 * this.depth * this.unitsPerPixel, n2, n3);
            }
        }
        throw new AssertionError();
    }

    private void updateImageDataPowerOfTwo(int n2) {
        assert (this.enforceNonPowerOfTwoSupport);
        BufferedImage bufferedImage = this.imageData.createBufferedImage(n2);
        BufferedImage bufferedImage2 = this.powerOfTwoATOp.filter(bufferedImage, null);
        this.copySupportedImageToImageData(bufferedImage2, 0, this.imageDataPowerOfTwo);
    }

    ImageData createRenderedImageDataObject(RenderedImage renderedImage) {
        return this.createRenderedImageDataObject(renderedImage, this.width, this.height);
    }

    void copySupportedImageToImageData(RenderedImage renderedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageData imageData) {
        int n9;
        int n10;
        int n11;
        assert (imageData != null);
        ColorModel colorModel = renderedImage.getColorModel();
        int n12 = renderedImage.getTileGridXOffset();
        int n13 = renderedImage.getTileGridYOffset();
        int n14 = renderedImage.getMinTileX();
        int n15 = renderedImage.getMinTileY();
        this.tilew = renderedImage.getTileWidth();
        this.tileh = renderedImage.getTileHeight();
        float f2 = (float)(n2 - n12) / (float)this.tilew;
        n14 = f2 < 0.0f ? (int)(f2 - 1.0f) : (int)f2;
        f2 = (float)(n3 - n13) / (float)this.tileh;
        n15 = f2 < 0.0f ? (int)(f2 - 1.0f) : (int)f2;
        int n16 = n14 * this.tilew + n12;
        int n17 = n15 * this.tileh + n13;
        int n18 = n16 + this.tilew - n2;
        int n19 = n17 + this.tileh - n3;
        if (n18 > n7) {
            n18 = n7;
        }
        if (n19 > n8) {
            n19 = n8;
        }
        int n20 = n18;
        int n21 = n7;
        int n22 = n8;
        int n23 = n2 - n16;
        int n24 = n3 - n17;
        this.numXTiles = (n7 + n23) / this.tilew;
        this.numYTiles = (n8 + n24) / this.tileh;
        if ((float)(n7 + n23) % (float)this.tilew > 0.0f) {
            ++this.numXTiles;
        }
        if ((float)(n8 + n24) % (float)this.tileh > 0.0f) {
            ++this.numYTiles;
        }
        Object object = null;
        byte[] byArray = null;
        int[] nArray = null;
        switch (imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byArray = imageData.getAsByteArray();
                break;
            }
            case TYPE_INT_ARRAY: {
                nArray = imageData.getAsIntArray();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        int n25 = imageData.dataWidth;
        int n26 = imageData.dataHeight;
        int n27 = n25 * this.unitsPerPixel;
        if (this.yUp) {
            n11 = (n6 * n25 * n26 + n5 * n25 + n4) * this.unitsPerPixel;
            n10 = 1;
            n9 = n27;
        } else {
            n11 = (n6 * n25 * n26 + (n26 - n5 - 1) * n25 + n4) * this.unitsPerPixel;
            n10 = -1;
            n9 = -n27;
        }
        Raster raster = renderedImage.getTile(n14, n15);
        object = ImageComponentRetained.getDataElementBuffer(raster);
        int n28 = this.tilew * this.unitsPerPixel;
        for (int i2 = n15; i2 < n15 + this.numYTiles; ++i2) {
            int n29 = n11;
            n21 = n7;
            n18 = n20;
            n23 = n2 - n16;
            for (int i3 = n14; i3 < n14 + this.numXTiles; ++i3) {
                raster = renderedImage.getTile(i3, i2);
                int n30 = (n24 * this.tilew + n23) * this.unitsPerPixel;
                int n31 = n29;
                int n32 = n18 * this.unitsPerPixel;
                switch (imageData.getType()) {
                    case TYPE_BYTE_ARRAY: {
                        int n33;
                        byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                        for (n33 = 0; n33 < n19; ++n33) {
                            System.arraycopy(byArray2, n30, byArray, n31, n32);
                            n30 += n28;
                            n31 += n9;
                        }
                        break;
                    }
                    case TYPE_INT_ARRAY: {
                        int n33;
                        int[] nArray2 = ((DataBufferInt)raster.getDataBuffer()).getData();
                        for (n33 = 0; n33 < n19; ++n33) {
                            System.arraycopy(nArray2, n30, nArray, n31, n32);
                            n30 += n28;
                            n31 += n9;
                        }
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                n29 += n18 * this.unitsPerPixel;
                n23 = 0;
                n18 = (n21 -= n18) < this.tilew ? n21 : this.tilew;
            }
            n11 += n25 * this.unitsPerPixel * n19 * n10;
            n24 = 0;
            n19 = (n22 -= n19) < this.tileh ? n22 : this.tileh;
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n6);
        }
    }

    void copyImageLineByLine(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageData imageData) {
        int n9;
        assert (imageData != null);
        int n10 = imageData.dataWidth;
        int n11 = imageData.dataHeight;
        int n12 = n10 * this.unitsPerPixel;
        int n13 = n3;
        if (this.yUp) {
            n9 = (n6 * n10 * n11 + n5 * n10 + n4) * this.unitsPerPixel;
        } else {
            n9 = (n6 * n10 * n11 + (n11 - n5 - 1) * n10 + n4) * this.unitsPerPixel;
            n12 = -1 * n12;
        }
        int n14 = n7 * this.unitsPerPixel;
        int n15 = bufferedImage.getWidth();
        int n16 = n15 * this.unitsPerPixel;
        int n17 = (n13 * n15 + n2) * this.unitsPerPixel;
        switch (imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray2 = imageData.getAsByteArray();
                for (int i2 = 0; i2 < n8; ++i2) {
                    System.arraycopy(byArray, n17, byArray2, n9, n14);
                    n9 += n12;
                    n17 += n16;
                }
                break;
            }
            case TYPE_INT_ARRAY: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int[] nArray2 = imageData.getAsIntArray();
                for (int i3 = 0; i3 < n8; ++i3) {
                    System.arraycopy(nArray, n17, nArray2, n9, n14);
                    n9 += n12;
                    n17 += n16;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n6);
        }
    }

    void copyImageByBlock(BufferedImage bufferedImage, int n2, ImageData imageData) {
        assert (imageData != null && this.yUp);
        int n3 = imageData.dataWidth;
        int n4 = imageData.dataHeight;
        int n5 = n2 * n3 * n4 * this.unitsPerPixel;
        switch (this.imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray2 = imageData.getAsByteArray();
                System.arraycopy(byArray, 0, byArray2, n5, n3 * n4 * this.unitsPerPixel);
                break;
            }
            case TYPE_INT_ARRAY: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int[] nArray2 = imageData.getAsIntArray();
                System.arraycopy(nArray, 0, nArray2, n5, n3 * n4 * this.unitsPerPixel);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n2);
        }
    }

    void copySupportedImageToImageData(RenderedImage renderedImage, int n2, ImageData imageData) {
        if (renderedImage instanceof BufferedImage) {
            if (this.yUp) {
                this.copyImageByBlock((BufferedImage)renderedImage, n2, imageData);
            } else {
                this.copyImageLineByLine((BufferedImage)renderedImage, 0, 0, 0, 0, n2, imageData.dataWidth, imageData.dataHeight, imageData);
            }
        } else {
            this.copySupportedImageToImageData(renderedImage, renderedImage.getMinX(), renderedImage.getMinY(), 0, 0, n2, imageData.dataWidth, imageData.dataHeight, imageData);
        }
    }

    void copyUnsupportedNioImageToImageData(NioImageBuffer nioImageBuffer, int n2, int n3, int n4, int n5, int n6, int n7, ImageData imageData) {
        if (MasterControl.isDevLoggable(Level.INFO)) {
            MasterControl.getDevLogger().info("ImageComponent - Copying Unsupported NioImage, use a different image type");
        }
        assert (imageData.getType() == ImageDataType.TYPE_BYTE_BUFFER);
        assert (this.getImageFormatType() == ImageFormatType.TYPE_BYTE_RGBA);
        int n8 = n6 * n7;
        ByteBuffer byteBuffer = (ByteBuffer)nioImageBuffer.getDataBuffer();
        byteBuffer.rewind();
        ByteBuffer byteBuffer2 = imageData.getAsByteBuffer();
        byteBuffer2.rewind();
        for (int i2 = 0; i2 < n8; i2 += 4) {
            byteBuffer2.put(i2, byteBuffer.get(i2 + 3));
            byteBuffer2.put(i2 + 1, byteBuffer.get(i2 + 2));
            byteBuffer2.put(i2 + 2, byteBuffer.get(i2 + 1));
            byteBuffer2.put(i2 + 3, byteBuffer.get(i2));
        }
    }

    void copyUnsupportedImageToImageData(RenderedImage renderedImage, int n2, ImageData imageData) {
        assert (imageData.getType() == ImageDataType.TYPE_BYTE_ARRAY);
        if (MasterControl.isDevLoggable(Level.INFO)) {
            MasterControl.getDevLogger().info("ImageComponent - Copying Unsupported Image, use a different image type");
        }
        if (renderedImage instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)renderedImage, 0, 0, 0, 0, n2, imageData.dataWidth, imageData.dataHeight, imageData);
        } else {
            this.copyUnsupportedImageToImageData(renderedImage, renderedImage.getMinX(), renderedImage.getMinY(), 0, 0, n2, imageData.dataWidth, imageData.dataHeight, imageData);
        }
    }

    void copyUnsupportedImageToImageData(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageData imageData) {
        int n9;
        int n10 = n3;
        int n11 = 1;
        assert (imageData != null);
        int n12 = imageData.dataWidth;
        int n13 = imageData.dataHeight;
        int n14 = n12 * this.unitsPerPixel;
        if (this.yUp) {
            n9 = (n6 * n12 * n13 + n5 * n12 + n4) * this.unitsPerPixel;
        } else {
            n9 = (n6 * n12 * n13 + (n13 - n5 - 1) * n12 + n4) * this.unitsPerPixel;
            n14 = -1 * n14;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        Object object = ImageComponentRetained.getDataElementBuffer(writableRaster);
        byte[] byArray = imageData.getAsByteArray();
        switch (this.numberOfComponents) {
            case 4: {
                int n15 = n10;
                int n16 = 0;
                while (n16 < n8) {
                    int n17 = n9;
                    for (int i2 = n2; i2 < n7 + n2; ++i2) {
                        writableRaster.getDataElements(i2, n15, object);
                        byArray[n17++] = (byte)colorModel.getRed(object);
                        byArray[n17++] = (byte)colorModel.getGreen(object);
                        byArray[n17++] = (byte)colorModel.getBlue(object);
                        byArray[n17++] = (byte)colorModel.getAlpha(object);
                    }
                    n9 += n14;
                    ++n16;
                    n15 += n11;
                }
                break;
            }
            case 3: {
                int n18 = n10;
                int n19 = 0;
                while (n19 < n8) {
                    int n20 = n9;
                    for (int i3 = n2; i3 < n7 + n2; ++i3) {
                        writableRaster.getDataElements(i3, n18, object);
                        byArray[n20++] = (byte)colorModel.getRed(object);
                        byArray[n20++] = (byte)colorModel.getGreen(object);
                        byArray[n20++] = (byte)colorModel.getBlue(object);
                    }
                    n9 += n14;
                    ++n19;
                    n18 += n11;
                }
                break;
            }
            case 2: {
                int n21 = n10;
                int n22 = 0;
                while (n22 < n8) {
                    int n23 = n9;
                    for (int i4 = n2; i4 < n7 + n2; ++i4) {
                        writableRaster.getDataElements(i4, n21, object);
                        byArray[n23++] = (byte)colorModel.getRed(object);
                        byArray[n23++] = (byte)colorModel.getAlpha(object);
                    }
                    n9 += n14;
                    ++n22;
                    n21 += n11;
                }
                break;
            }
            case 1: {
                int n24 = n10;
                int n25 = 0;
                while (n25 < n8) {
                    int n26 = n9;
                    for (int i5 = n2; i5 < n7 + n2; ++i5) {
                        writableRaster.getDataElements(i5, n24, object);
                        byArray[n26++] = (byte)colorModel.getRed(object);
                    }
                    n9 += n14;
                    ++n25;
                    n24 += n11;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n6);
        }
    }

    void copyUnsupportedImageToImageData(RenderedImage renderedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageData imageData) {
        int n9;
        int n10;
        int n11;
        Object object = null;
        ColorModel colorModel = renderedImage.getColorModel();
        int n12 = renderedImage.getTileGridXOffset();
        int n13 = renderedImage.getTileGridYOffset();
        int n14 = renderedImage.getMinTileX();
        int n15 = renderedImage.getMinTileY();
        this.tilew = renderedImage.getTileWidth();
        this.tileh = renderedImage.getTileHeight();
        float f2 = (float)(n2 - n12) / (float)this.tilew;
        n14 = f2 < 0.0f ? (int)(f2 - 1.0f) : (int)f2;
        f2 = (float)(n3 - n13) / (float)this.tileh;
        n15 = f2 < 0.0f ? (int)(f2 - 1.0f) : (int)f2;
        int n16 = n14 * this.tilew + n12;
        int n17 = n15 * this.tileh + n13;
        int n18 = n16 + this.tilew - n2;
        int n19 = n17 + this.tileh - n3;
        if (n18 > n7) {
            n18 = n7;
        }
        if (n19 > n8) {
            n19 = n8;
        }
        int n20 = n18;
        int n21 = n7;
        int n22 = n8;
        int n23 = n2 - n16;
        int n24 = n3 - n17;
        this.numXTiles = (n7 + n23) / this.tilew;
        this.numYTiles = (n8 + n24) / this.tileh;
        if ((float)(n7 + n23) % (float)this.tilew > 0.0f) {
            ++this.numXTiles;
        }
        if ((float)(n8 + n24) % (float)this.tileh > 0.0f) {
            ++this.numYTiles;
        }
        assert (imageData != null);
        int n25 = imageData.dataWidth;
        int n26 = imageData.dataHeight;
        int n27 = n25 * this.unitsPerPixel;
        if (this.yUp) {
            n11 = (n6 * n25 * n26 + n5 * n25 + n4) * this.unitsPerPixel;
            n10 = 1;
            n9 = n27;
        } else {
            n11 = (n6 * n25 * n26 + (n26 - n5 - 1) * n25 + n4) * this.unitsPerPixel;
            n10 = -1;
            n9 = -n27;
        }
        Raster raster = renderedImage.getTile(n14, n15);
        object = ImageComponentRetained.getDataElementBuffer(raster);
        byte[] byArray = this.imageData.getAsByteArray();
        switch (this.numberOfComponents) {
            case 4: {
                for (int i2 = n15; i2 < n15 + this.numYTiles; ++i2) {
                    int n28 = n11;
                    n21 = n7;
                    n18 = n20;
                    n23 = n2 - n16;
                    for (int i3 = n14; i3 < n14 + this.numXTiles; ++i3) {
                        raster = renderedImage.getTile(i3, i2);
                        int n29 = n28;
                        int n30 = 0;
                        for (int i4 = n24; i4 < n24 + n19; ++i4) {
                            for (int i5 = n23; i5 < n23 + n18; ++i5) {
                                raster.getDataElements(i5, i4, object);
                                byArray[n29++] = (byte)colorModel.getRed(object);
                                byArray[n29++] = (byte)colorModel.getGreen(object);
                                byArray[n29++] = (byte)colorModel.getBlue(object);
                                byArray[n29++] = (byte)colorModel.getAlpha(object);
                            }
                            n29 = n28 + (n30 += n9);
                        }
                        n28 += n18 * this.unitsPerPixel;
                        n23 = 0;
                        n18 = (n21 -= n18) < this.tilew ? n21 : this.tilew;
                    }
                    n11 += n25 * this.unitsPerPixel * n19 * n10;
                    n24 = 0;
                    n19 = (n22 -= n19) < this.tileh ? n22 : this.tileh;
                }
                break;
            }
            case 3: {
                for (int i6 = n15; i6 < n15 + this.numYTiles; ++i6) {
                    int n31 = n11;
                    n21 = n7;
                    n18 = n20;
                    n23 = n2 - n16;
                    for (int i7 = n14; i7 < n14 + this.numXTiles; ++i7) {
                        raster = renderedImage.getTile(i7, i6);
                        int n32 = n31;
                        int n33 = 0;
                        for (int i8 = n24; i8 < n24 + n19; ++i8) {
                            for (int i9 = n23; i9 < n23 + n18; ++i9) {
                                raster.getDataElements(i9, i8, object);
                                byArray[n32++] = (byte)colorModel.getRed(object);
                                byArray[n32++] = (byte)colorModel.getGreen(object);
                                byArray[n32++] = (byte)colorModel.getBlue(object);
                            }
                            n32 = n31 + (n33 += n9);
                        }
                        n31 += n18 * this.unitsPerPixel;
                        n23 = 0;
                        n18 = (n21 -= n18) < this.tilew ? n21 : this.tilew;
                    }
                    n11 += n25 * this.unitsPerPixel * n19 * n10;
                    n24 = 0;
                    n19 = (n22 -= n19) < this.tileh ? n22 : this.tileh;
                }
                break;
            }
            case 2: {
                for (int i10 = n15; i10 < n15 + this.numYTiles; ++i10) {
                    int n34 = n11;
                    n21 = n7;
                    n18 = n20;
                    n23 = n2 - n16;
                    for (int i11 = n14; i11 < n14 + this.numXTiles; ++i11) {
                        raster = renderedImage.getTile(i11, i10);
                        int n35 = n34;
                        int n36 = 0;
                        for (int i12 = n24; i12 < n24 + n19; ++i12) {
                            for (int i13 = n23; i13 < n23 + n18; ++i13) {
                                raster.getDataElements(i13, i12, object);
                                byArray[n35++] = (byte)colorModel.getRed(object);
                                byArray[n35++] = (byte)colorModel.getAlpha(object);
                            }
                            n35 = n34 + (n36 += n9);
                        }
                        n34 += n18 * this.unitsPerPixel;
                        n23 = 0;
                        n18 = (n21 -= n18) < this.tilew ? n21 : this.tilew;
                    }
                    n11 += n25 * this.unitsPerPixel * n19 * n10;
                    n24 = 0;
                    n19 = (n22 -= n19) < this.tileh ? n22 : this.tileh;
                }
                break;
            }
            case 1: {
                for (int i14 = n15; i14 < n15 + this.numYTiles; ++i14) {
                    int n37 = n11;
                    n21 = n7;
                    n18 = n20;
                    n23 = n2 - n16;
                    for (int i15 = n14; i15 < n14 + this.numXTiles; ++i15) {
                        raster = renderedImage.getTile(i15, i14);
                        int n38 = n37;
                        int n39 = 0;
                        for (int i16 = n24; i16 < n24 + n19; ++i16) {
                            for (int i17 = n23; i17 < n23 + n18; ++i17) {
                                raster.getDataElements(i17, i16, object);
                                byArray[n38++] = (byte)colorModel.getRed(object);
                            }
                            n38 = n37 + (n39 += n9);
                        }
                        n37 += n18 * this.unitsPerPixel;
                        n23 = 0;
                        n18 = (n21 -= n18) < this.tilew ? n21 : this.tilew;
                    }
                    n11 += n25 * this.unitsPerPixel * n19 * n10;
                    n24 = 0;
                    n19 = (n22 -= n19) < this.tileh ? n22 : this.tileh;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateExtensions(Canvas3D canvas3D) {
        Object object = this.evaluateExtLock;
        synchronized (object) {
            this.evaluateExtABGR(canvas3D.extensionsSupported);
            this.evaluateExtNonPowerOfTwo(canvas3D.textureExtendedFeatures);
        }
    }

    void evaluateExtABGR(int n2) {
        if (!this.abgrSupported) {
            return;
        }
        if (this.getImageFormatType() != ImageFormatType.TYPE_BYTE_ABGR) {
            return;
        }
        if ((n2 & 2) != 0) {
            return;
        }
        this.abgrSupported = false;
        this.convertImageDataFromABGRToRGBA();
    }

    private int getClosestPowerOf2(int n2) {
        if (n2 < 1) {
            return n2;
        }
        int n3 = 1;
        while (n2 >= (n3 *= 2)) {
        }
        int n4 = n3 / 2;
        if (n3 - n2 > n2 - n4) {
            return n4;
        }
        return n3;
    }

    private int getCeilPowerOf2(int n2) {
        if (n2 < 1) {
            return n2;
        }
        int n3 = 1;
        while (n2 > (n3 *= 2)) {
        }
        return n3;
    }

    void evaluateExtNonPowerOfTwo(int n2) {
        int n3;
        int n4;
        if (!this.enforceNonPowerOfTwoSupport) {
            return;
        }
        if (!this.npotSupported) {
            return;
        }
        if (this.imageData == null && !this.isByReference()) {
            return;
        }
        if ((n2 & 0x8000) != 0) {
            return;
        }
        this.npotSupported = false;
        if (this.width * this.height < 262144) {
            n4 = this.getCeilPowerOf2(this.width);
            n3 = this.getCeilPowerOf2(this.height);
        } else {
            n4 = this.getClosestPowerOf2(this.width);
            n3 = this.getClosestPowerOf2(this.height);
        }
        float f2 = (float)n4 / (float)this.width;
        float f3 = (float)n3 / (float)this.height;
        if (f2 != 1.0f || f3 != 1.0f) {
            Object object;
            RenderedImage renderedImage;
            if (this.imageData == null) {
                renderedImage = (RenderedImage)this.getRefImage(0);
                assert (!(renderedImage instanceof BufferedImage));
                ColorModel colorModel = renderedImage.getColorModel();
                object = renderedImage.copyData(null);
                renderedImage = new BufferedImage(colorModel, (WritableRaster)object, colorModel.isAlphaPremultiplied(), null);
                this.imageData = this.createRenderedImageDataObject(null);
                this.copySupportedImageToImageData(renderedImage, 0, this.imageData);
            }
            assert (this.imageData != null);
            renderedImage = this.imageData.createBufferedImage(0);
            int n5 = ((BufferedImage)renderedImage).getType();
            object = new BufferedImage(n4, n3, n5);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(f2, f3);
            this.powerOfTwoATOp = new AffineTransformOp(affineTransform, 2);
            this.powerOfTwoATOp.filter((BufferedImage)renderedImage, (BufferedImage)object);
            this.imageDataPowerOfTwo = this.createRenderedImageDataObject(null, n4, n3);
            this.copySupportedImageToImageData((RenderedImage)object, 0, this.imageDataPowerOfTwo);
        } else {
            this.imageDataPowerOfTwo = null;
        }
    }

    void convertImageDataFromABGRToRGBA() {
        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
        this.imageTypeIsSupported = false;
        this.imageData.convertFromABGRToRGBA();
    }

    void copyToRefImage(int n2) {
        int n3;
        assert (this.refImage[n2] != null);
        assert (this.refImage[n2] instanceof BufferedImage);
        BufferedImage bufferedImage = (BufferedImage)this.refImage[n2];
        int n4 = this.width * this.unitsPerPixel;
        int n5 = 0;
        if (this.yUp) {
            n3 = n2 * this.width * this.height * this.unitsPerPixel;
        } else {
            n3 = (n2 * this.width * this.height + (this.height - 1) * this.width) * this.unitsPerPixel;
            n4 = -1 * n4;
        }
        int n6 = this.width * this.unitsPerPixel;
        int n7 = n5 * this.width * this.unitsPerPixel;
        switch (this.imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray2 = this.imageData.getAsByteArray();
                for (int i2 = 0; i2 < this.height; ++i2) {
                    System.arraycopy(byArray2, n7, byArray, n3, n6);
                    n3 += n4;
                    n7 += n6;
                }
                break;
            }
            case TYPE_INT_ARRAY: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int[] nArray2 = this.imageData.getAsIntArray();
                for (int i3 = 0; i3 < this.height; ++i3) {
                    System.arraycopy(nArray2, n7, nArray, n3, n6);
                    n3 += n4;
                    n7 += n6;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void copyToRefImageWithFormatConversion(int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        assert (this.refImage[n2] != null);
        assert (this.refImage[n2] instanceof BufferedImage);
        BufferedImage bufferedImage = (BufferedImage)this.refImage[n2];
        int n7 = bufferedImage.getType();
        byte[] byArray = this.imageData.getAsByteArray();
        if (!this.yUp) {
            n6 = -1 * this.width;
            n5 = (this.height - 1) * this.width;
            n4 = this.height - 1;
            n3 = -1;
        } else {
            n6 = this.width;
            n5 = 0;
            n4 = 0;
            n3 = 1;
        }
        block0 : switch (n7) {
            case 2: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n8 = 0;
                switch (this.imageFormatType) {
                    case TYPE_BYTE_RGBA: {
                        int n9 = 0;
                        while (n9 < this.height) {
                            int n10 = n5;
                            int n11 = 0;
                            while (n11 < this.width) {
                                nArray[n10] = (byArray[n8 + 3] & 0xFF) << 24 | (byArray[n8] & 0xFF) << 16 | (byArray[n8 + 1] & 0xFF) << 8 | byArray[n8 + 2] & 0xFF;
                                ++n11;
                                n8 += 4;
                                ++n10;
                            }
                            ++n9;
                            n5 += n6;
                        }
                        break block0;
                    }
                    case TYPE_BYTE_RGB: {
                        int n12 = 0;
                        while (n12 < this.height) {
                            int n13 = n5;
                            int n14 = 0;
                            while (n14 < this.width) {
                                nArray[n13] = 0xFF000000 | (byArray[n8] & 0xFF) << 16 | (byArray[n8 + 1] & 0xFF) << 8 | byArray[n8 + 2] & 0xFF;
                                ++n14;
                                n8 += 3;
                                ++n13;
                            }
                            ++n12;
                            n5 += n6;
                        }
                        break block0;
                    }
                    default: {
                        assert (false);
                        break block0;
                    }
                }
            }
            case 1: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n15 = 0;
                int n16 = 0;
                while (n16 < this.height) {
                    int n17 = n5;
                    int n18 = 0;
                    while (n18 < this.width) {
                        nArray[n17] = 0xFF000000 | (byArray[n15] & 0xFF) << 16 | (byArray[n15 + 1] & 0xFF) << 8 | byArray[n15 + 2] & 0xFF;
                        ++n18;
                        n15 += 4;
                        ++n17;
                    }
                    ++n16;
                    n5 += n6;
                }
                break;
            }
            case 6: {
                byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n19 = 0;
                n5 <<= 2;
                switch (this.imageFormatType) {
                    case TYPE_BYTE_RGBA: {
                        int n20 = 0;
                        while (n20 < this.height) {
                            int n21 = n5;
                            int n22 = 0;
                            while (n22 < this.width) {
                                byArray2[n21++] = byArray[n19 + 3];
                                byArray2[n21++] = byArray[n19 + 2];
                                byArray2[n21++] = byArray[n19 + 1];
                                byArray2[n21++] = byArray[n19];
                                ++n22;
                                n19 += 4;
                            }
                            ++n20;
                            n5 += n6 << 2;
                        }
                        break block0;
                    }
                    case TYPE_BYTE_RGB: {
                        int n23 = 0;
                        while (n23 < this.height) {
                            int n24 = n5;
                            int n25 = 0;
                            while (n25 < this.width) {
                                byArray2[n24++] = -1;
                                byArray2[n24++] = byArray[n19 + 2];
                                byArray2[n24++] = byArray[n19 + 1];
                                byArray2[n24++] = byArray[n19];
                                ++n25;
                                n19 += 3;
                            }
                            ++n23;
                            n5 += n6 << 2;
                        }
                        break block0;
                    }
                    default: {
                        assert (false);
                        break block0;
                    }
                }
            }
            case 4: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n26 = 0;
                int n27 = 0;
                while (n27 < this.height) {
                    int n28 = n5;
                    int n29 = 0;
                    while (n29 < this.width) {
                        nArray[n28] = 0xFF000000 | byArray[n26] & 0xFF | (byArray[n26 + 1] & 0xFF) << 8 | (byArray[n26 + 2] & 0xFF) << 16;
                        ++n29;
                        n26 += 4;
                        ++n28;
                    }
                    ++n27;
                    n5 += n6;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    synchronized void addUser(NodeComponentRetained nodeComponentRetained) {
        this.userList.add(nodeComponentRetained);
    }

    synchronized void removeUser(NodeComponentRetained nodeComponentRetained) {
        int n2 = this.userList.indexOf(nodeComponentRetained);
        if (n2 >= 0) {
            this.userList.remove(n2);
        }
    }

    void setLive(boolean bl, int n2) {
        if (this.getUsedByOffScreen()) {
            throw new IllegalSharingException(J3dI18N.getString("ImageComponent3"));
        }
        super.setLive(bl, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateMirrorObject(int n2, Object object) {
        if ((n2 & 1) != 0 || (n2 & 2) != 0) {
            ArrayList arrayList = this.userList;
            synchronized (arrayList) {
                for (int i2 = this.userList.size() - 1; i2 >= 0; --i2) {
                    Object e2 = this.userList.get(i2);
                    if (e2 == null) continue;
                    if (e2 instanceof TextureRetained) {
                        ((TextureRetained)e2).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)object);
                        continue;
                    }
                    if (e2 instanceof RasterRetained) {
                        ((RasterRetained)e2).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)object);
                        continue;
                    }
                    if (!(e2 instanceof BackgroundRetained)) continue;
                    ((BackgroundRetained)e2).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)object);
                }
            }
        }
    }

    final void sendMessage(int n2, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1152;
        j3dMessage.type = 54;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void handleFrequencyChange(int n2) {
        if (n2 == 3) {
            this.setFrequencyChangeMask(3, 1);
        }
    }

    static Object getDataElementBuffer(Raster raster) {
        int n2 = raster.getNumDataElements();
        switch (raster.getTransferType()) {
            case 3: {
                return new int[n2];
            }
            case 0: {
                return new byte[n2];
            }
            case 1: 
            case 2: {
                return new short[n2];
            }
            case 4: {
                return new float[n2];
            }
            case 5: {
                return new double[n2];
            }
        }
        return null;
    }

    class ImageData {
        private Object data = null;
        private ImageDataType imageDataType = ImageDataType.TYPE_NULL;
        private int length = 0;
        private boolean dataIsByRef = false;
        private int dataWidth;
        private int dataHeight;

        ImageData(ImageDataType imageDataType, int n2, int n3, int n4) {
            this.imageDataType = imageDataType;
            this.length = n2;
            this.dataWidth = n3;
            this.dataHeight = n4;
            this.dataIsByRef = false;
            switch (imageDataType) {
                case TYPE_BYTE_ARRAY: {
                    this.data = new byte[n2];
                    break;
                }
                case TYPE_INT_ARRAY: {
                    this.data = new int[n2];
                    break;
                }
                case TYPE_BYTE_BUFFER: {
                    ByteOrder byteOrder = ByteOrder.nativeOrder();
                    this.data = ByteBuffer.allocateDirect(n2).order(byteOrder);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        ImageData(ImageDataType imageDataType, int n2, int n3, int n4, Object object) {
            this.imageDataType = imageDataType;
            this.length = n2;
            this.dataWidth = n3;
            this.dataHeight = n4;
            this.dataIsByRef = true;
            switch (imageDataType) {
                case TYPE_BYTE_ARRAY: {
                    BufferedImage bufferedImage = (BufferedImage)object;
                    this.data = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                    break;
                }
                case TYPE_INT_ARRAY: {
                    BufferedImage bufferedImage = (BufferedImage)object;
                    this.data = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    break;
                }
                case TYPE_BYTE_BUFFER: 
                case TYPE_INT_BUFFER: {
                    NioImageBuffer nioImageBuffer = (NioImageBuffer)object;
                    this.data = nioImageBuffer.getDataBuffer();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        ImageData(Object object, boolean bl) {
            this.data = object;
            this.dataIsByRef = bl;
            this.dataWidth = ((ImageData)object).dataWidth;
            this.dataHeight = ((ImageData)object).dataHeight;
            if (object == null) {
                this.imageDataType = ImageDataType.TYPE_NULL;
                this.length = 0;
            } else if (object instanceof byte[]) {
                this.imageDataType = ImageDataType.TYPE_BYTE_ARRAY;
                this.length = ((byte[])object).length;
            } else if (object instanceof int[]) {
                this.imageDataType = ImageDataType.TYPE_INT_ARRAY;
                this.length = ((int[])object).length;
            } else if (object instanceof ByteBuffer) {
                this.imageDataType = ImageDataType.TYPE_BYTE_BUFFER;
                this.length = ((ByteBuffer)object).limit();
            } else if (object instanceof IntBuffer) {
                this.imageDataType = ImageDataType.TYPE_INT_BUFFER;
                this.length = ((IntBuffer)object).limit();
            } else assert (false);
        }

        ImageDataType getType() {
            return this.imageDataType;
        }

        int length() {
            return this.length;
        }

        int getWidth() {
            return this.dataWidth;
        }

        int getHeight() {
            return this.dataHeight;
        }

        Object get() {
            return this.data;
        }

        boolean isDataByRef() {
            return this.dataIsByRef;
        }

        byte[] getAsByteArray() {
            return (byte[])this.data;
        }

        int[] getAsIntArray() {
            return (int[])this.data;
        }

        ByteBuffer getAsByteBuffer() {
            return (ByteBuffer)this.data;
        }

        IntBuffer getAsIntBuffer() {
            return (IntBuffer)this.data;
        }

        void copyByLineAndExpand(BufferedImage bufferedImage, int n2) {
            int n3;
            int n4;
            assert (ImageComponentRetained.this.imageData.getType() == ImageDataType.TYPE_BYTE_ARRAY);
            assert (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_LA);
            int n5 = n4 = ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel;
            if (ImageComponentRetained.this.yUp) {
                n3 = n2 * ImageComponentRetained.this.width * ImageComponentRetained.this.height * ImageComponentRetained.this.unitsPerPixel;
            } else {
                n3 = (n2 * ImageComponentRetained.this.width * ImageComponentRetained.this.height + (ImageComponentRetained.this.height - 1) * ImageComponentRetained.this.width) * ImageComponentRetained.this.unitsPerPixel;
                n4 = -1 * n4;
            }
            int n6 = 0;
            int n7 = ImageComponentRetained.this.width * 4;
            byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            byte[] byArray2 = ImageComponentRetained.this.imageData.getAsByteArray();
            for (int i2 = 0; i2 < ImageComponentRetained.this.height; ++i2) {
                int n8 = 0;
                int n9 = 0;
                while (n9 < n5) {
                    byArray[n6 + n8] = byArray2[n3 + n9 + 1];
                    byArray[n6 + n8 + 1] = 0;
                    byArray[n6 + n8 + 2] = 0;
                    byArray[n6 + n8 + 3] = byArray2[n3 + n9];
                    n9 += ImageComponentRetained.this.unitsPerPixel;
                    n8 += 4;
                }
                n6 += n7;
                n3 += n4;
            }
        }

        void copyByLine(BufferedImage bufferedImage, int n2, boolean bl) {
            int n3;
            int n4;
            int n5 = n4 = ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel;
            if (ImageComponentRetained.this.yUp) {
                n3 = n2 * ImageComponentRetained.this.width * ImageComponentRetained.this.height * ImageComponentRetained.this.unitsPerPixel;
            } else {
                n3 = (n2 * ImageComponentRetained.this.width * ImageComponentRetained.this.height + (ImageComponentRetained.this.height - 1) * ImageComponentRetained.this.width) * ImageComponentRetained.this.unitsPerPixel;
                n4 = -1 * n4;
            }
            int n6 = 0;
            switch (ImageComponentRetained.this.imageData.getType()) {
                case TYPE_BYTE_ARRAY: {
                    byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                    byte[] byArray2 = ImageComponentRetained.this.imageData.getAsByteArray();
                    for (int i2 = 0; i2 < ImageComponentRetained.this.height; ++i2) {
                        int n7;
                        if (!bl) {
                            System.arraycopy(byArray2, n3, byArray, n6, n5);
                        } else if (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_RGB) {
                            assert (ImageComponentRetained.this.unitsPerPixel == 3);
                            for (n7 = 0; n7 < n5; n7 += ImageComponentRetained.this.unitsPerPixel) {
                                byArray[n6 + n7] = byArray2[n3 + n7 + 2];
                                byArray[n6 + n7 + 1] = byArray2[n3 + n7 + 1];
                                byArray[n6 + n7 + 2] = byArray2[n3 + n7];
                            }
                        } else if (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_RGBA) {
                            assert (ImageComponentRetained.this.unitsPerPixel == 4);
                            for (n7 = 0; n7 < n5; n7 += ImageComponentRetained.this.unitsPerPixel) {
                                byArray[n6 + n7] = byArray2[n3 + n7 + 3];
                                byArray[n6 + n7 + 1] = byArray2[n3 + n7 + 2];
                                byArray[n6 + n7 + 2] = byArray2[n3 + n7 + 1];
                                byArray[n6 + n7 + 3] = byArray2[n3 + n7];
                            }
                        } else assert (false);
                        n6 += n5;
                        n3 += n4;
                    }
                    break;
                }
                case TYPE_INT_ARRAY: {
                    assert (!bl);
                    int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    int[] nArray2 = ImageComponentRetained.this.imageData.getAsIntArray();
                    for (int i3 = 0; i3 < ImageComponentRetained.this.height; ++i3) {
                        System.arraycopy(nArray2, n3, nArray, n6, n5);
                        n6 += n5;
                        n3 += n4;
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        void copyByBlock(BufferedImage bufferedImage, int n2) {
            int n3 = n2 * ImageComponentRetained.this.width * ImageComponentRetained.this.height * ImageComponentRetained.this.unitsPerPixel;
            switch (ImageComponentRetained.this.imageData.getType()) {
                case TYPE_BYTE_ARRAY: {
                    byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                    byte[] byArray2 = ImageComponentRetained.this.imageData.getAsByteArray();
                    System.arraycopy(byArray2, n3, byArray, 0, ImageComponentRetained.this.height * ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel);
                    break;
                }
                case TYPE_INT_ARRAY: {
                    int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    int[] nArray2 = ImageComponentRetained.this.imageData.getAsIntArray();
                    System.arraycopy(nArray2, n3, nArray, 0, ImageComponentRetained.this.height * ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        BufferedImage createBufferedImage(int n2) {
            if (this.data != null) {
                int n3 = 0;
                boolean bl = false;
                switch (ImageComponentRetained.this.imageFormatType) {
                    case TYPE_BYTE_BGR: {
                        n3 = 5;
                        break;
                    }
                    case TYPE_BYTE_RGB: {
                        n3 = 5;
                        bl = true;
                        break;
                    }
                    case TYPE_BYTE_ABGR: {
                        n3 = 6;
                        break;
                    }
                    case TYPE_BYTE_RGBA: {
                        n3 = 6;
                        bl = true;
                        break;
                    }
                    case TYPE_BYTE_LA: {
                        n3 = 6;
                        break;
                    }
                    case TYPE_BYTE_GRAY: {
                        n3 = 10;
                        break;
                    }
                    case TYPE_INT_BGR: {
                        n3 = 4;
                        break;
                    }
                    case TYPE_INT_RGB: {
                        n3 = 1;
                        break;
                    }
                    case TYPE_INT_ARGB: {
                        n3 = 2;
                        break;
                    }
                    case TYPE_USHORT_GRAY: {
                        n3 = 11;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                BufferedImage bufferedImage = new BufferedImage(ImageComponentRetained.this.width, ImageComponentRetained.this.height, n3);
                if (!bl && ImageComponentRetained.this.imageFormatType != ImageFormatType.TYPE_BYTE_LA) {
                    if (ImageComponentRetained.this.yUp) {
                        this.copyByBlock(bufferedImage, n2);
                    } else {
                        this.copyByLine(bufferedImage, n2, false);
                    }
                } else if (bl) {
                    this.copyByLine(bufferedImage, n2, bl);
                } else if (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_LA) {
                    this.copyByLineAndExpand(bufferedImage, n2);
                } else assert (false);
                return bufferedImage;
            }
            return null;
        }

        void convertFromABGRToRGBA() {
            if (this.imageDataType == ImageDataType.TYPE_BYTE_ARRAY) {
                byte[] byArray = this.getAsByteArray();
                if (this.dataIsByRef) {
                    byte[] byArray2 = new byte[this.length];
                    for (int i2 = 0; i2 < this.length; i2 += 4) {
                        byArray2[i2] = byArray[i2 + 3];
                        byArray2[i2 + 1] = byArray[i2 + 2];
                        byArray2[i2 + 2] = byArray[i2 + 1];
                        byArray2[i2 + 3] = byArray[i2];
                    }
                    this.data = byArray2;
                    this.dataIsByRef = false;
                } else {
                    for (int i3 = 0; i3 < this.length; i3 += 4) {
                        byte by = byArray[i3];
                        byte by2 = byArray[i3 + 1];
                        byArray[i3] = byArray[i3 + 3];
                        byArray[i3 + 1] = byArray[i3 + 2];
                        byArray[i3 + 2] = by2;
                        byArray[i3 + 3] = by;
                    }
                }
            } else if (this.imageDataType == ImageDataType.TYPE_BYTE_BUFFER) {
                assert (this.dataIsByRef);
                ByteBuffer byteBuffer = this.getAsByteBuffer();
                byteBuffer.rewind();
                ByteOrder byteOrder = ByteOrder.nativeOrder();
                ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.length).order(byteOrder);
                byteBuffer2.rewind();
                for (int i4 = 0; i4 < this.length; i4 += 4) {
                    byteBuffer2.put(i4, byteBuffer.get(i4 + 3));
                    byteBuffer2.put(i4 + 1, byteBuffer.get(i4 + 2));
                    byteBuffer2.put(i4 + 2, byteBuffer.get(i4 + 1));
                    byteBuffer2.put(i4 + 3, byteBuffer.get(i4));
                }
                this.dataIsByRef = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ImageDataType {
        TYPE_NULL,
        TYPE_BYTE_ARRAY,
        TYPE_INT_ARRAY,
        TYPE_BYTE_BUFFER,
        TYPE_INT_BUFFER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ImageFormatType {
        TYPE_UNKNOWN,
        TYPE_BYTE_BGR,
        TYPE_BYTE_RGB,
        TYPE_BYTE_ABGR,
        TYPE_BYTE_RGBA,
        TYPE_BYTE_LA,
        TYPE_BYTE_GRAY,
        TYPE_USHORT_GRAY,
        TYPE_INT_BGR,
        TYPE_INT_RGB,
        TYPE_INT_ARGB;

    }
}

